<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
package ${pub.getPKGCodeName()};

import java.util.List;

import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import ${pub.getPKGCodeName()}.util.web.SearchContextHandlerMethodArgumentResolver;
import ${pub.getPKGCodeName()}.util.serialize.DomainSerializerProvider;
import ${pub.getPKGCodeName()}.util.helper.UniqueNameGenerator;

@SpringBootApplication(exclude = {

})
@Import({
//    ${pub.getPKGCodeName()}
})
@EnableDiscoveryClient
@Configuration
@ComponentScan(nameGenerator = UniqueNameGenerator.class)
@EnableTransactionManagement
public class ${pub.codeName?cap_first}Application extends WebMvcConfigurerAdapter {

    public static void main(String[] args) {
        SpringApplicationBuilder builder=new SpringApplicationBuilder(${pub.codeName?cap_first}Application.class);
        builder.run(args);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJacksonHttpMessageConverter(ObjectMapper objectMapper) {
    	objectMapper.setSerializerProvider(new DomainSerializerProvider()) ;
    	final MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(objectMapper);
        return converter;
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
        argumentResolvers.add(new SearchContextHandlerMethodArgumentResolver());
    }
}
